/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import jclass.bwt.HeaderButton;
import jclass.bwt.HeaderConverter;
import jclass.bwt.HeaderLabel;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMultiColumnData;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.Viewport;
import jclass.util.JCVector;

public class JCHeader
extends JCContainer
implements JCMultiColumnInterface {
    protected JCMultiColumnData data = new JCMultiColumnData(this);
    protected JCMultiColumnInterface comp;
    protected int resize_col = -999;
    protected boolean resizing = false;
    boolean num_columns_set = false;
    boolean update_parent = true;
    boolean batched = false;
    protected JCVector actionListeners = new JCVector(0);
    private static final String base = "header";
    private static int nameCounter;
    private static final boolean TRACE = false;
    private int mouse_down_x = -999;
    private static int x_save;

    public JCHeader() {
        this(null, null, null);
    }

    public JCHeader(String[] stringArray) {
        this(stringArray, null, null);
    }

    public JCHeader(JCVector jCVector) {
        this(null, null, null);
        if (jCVector != null) {
            this.setLabels(jCVector);
        }
    }

    public JCHeader(String[] stringArray, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        if (this.getClass().getName().equals("jclass.bwt.JCHeader")) {
            this.getParameters(applet);
        }
        if (stringArray != null) {
            this.setLabels(new JCVector(stringArray));
        }
    }

    protected void getParameters() {
        super.getParameters();
        HeaderConverter.getParams(this);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() == null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            ((JCLabel)componentArray[n]).setFontInternal(font);
            ++n;
        }
        this.data.calcColumnWidths();
        this.resize(JCComponent.getPreferredSize((Component)this).width, this.size().height);
        this.layout();
        this.repaint();
    }

    public JCMultiColumnInterface getMultiColumnComponent() {
        return this.comp;
    }

    public void setMultiColumnComponent(JCMultiColumnInterface jCMultiColumnInterface) {
        if (this.comp == jCMultiColumnInterface) {
            return;
        }
        this.comp = jCMultiColumnInterface;
        if (jCMultiColumnInterface instanceof JCComponent) {
            this.insets = new Insets(0, ((JCComponent)((Object)jCMultiColumnInterface)).getInsets().left, 0, ((JCComponent)((Object)jCMultiColumnInterface)).getInsets().right);
        }
        int[] nArray = jCMultiColumnInterface.getColumnWidths();
        int[] nArray2 = jCMultiColumnInterface.getColumnDisplayWidths();
        int n = 0;
        while (n < jCMultiColumnInterface.getNumColumns()) {
            this.data.setColumnAlignment(n, jCMultiColumnInterface.getColumnAlignment(n));
            this.data.setColumnRightMargin(n, jCMultiColumnInterface.getColumnRightMargin(n));
            this.data.setColumnLeftMargin(n, jCMultiColumnInterface.getColumnLeftMargin(n));
            if (n < nArray.length) {
                this.data.setColumnWidth(n, nArray[n]);
            }
            if (n < nArray2.length) {
                this.data.setColumnDisplayWidth(n, nArray2[n]);
            }
            ++n;
        }
        this.layout();
        this.repaint();
    }

    public JCComponent[] getLabels() {
        Component[] componentArray = this.getComponents();
        JCComponent[] jCComponentArray = new JCComponent[componentArray.length];
        int n = 0;
        while (n < componentArray.length) {
            jCComponentArray[n] = (JCComponent)componentArray[n];
            ++n;
        }
        return jCComponentArray;
    }

    public JCComponent getLabel(int n) {
        Component[] componentArray = this.getComponents();
        return (JCComponent)componentArray[n];
    }

    public void setColumnLabels(JCVector jCVector) {
        this.setLabels(jCVector);
    }

    public void setLabels(JCVector jCVector) {
        this.removeAll();
        if (!this.num_columns_set) {
            this.data.setNumColumns(0);
        }
        this.update_parent = false;
        int n = 0;
        while (jCVector != null && n < jCVector.size()) {
            this.addLabel(jCVector.elementAt(n));
            ++n;
        }
        this.update_parent = true;
        this.recalc();
        this.updateParent();
    }

    public void setColumnButtons(JCVector jCVector) {
        this.setButtons(jCVector);
    }

    public void setButtons(JCVector jCVector) {
        this.removeAll();
        if (!this.num_columns_set) {
            this.data.setNumColumns(0);
        }
        this.update_parent = false;
        int n = 0;
        while (jCVector != null && n < jCVector.size()) {
            this.addButton(jCVector.elementAt(n));
            ++n;
        }
        this.update_parent = true;
        this.recalc();
        this.updateParent();
    }

    public JCLabel addLabel(Object object) {
        HeaderLabel headerLabel = new HeaderLabel(this, object);
        if (!this.num_columns_set) {
            this.data.setNumColumns(this.getNumColumns() + 1);
        }
        this.add(headerLabel);
        this.updateParent();
        return headerLabel;
    }

    public JCButton addButton(Object object) {
        HeaderButton headerButton = new HeaderButton(this, object);
        int n = 0;
        while (n < this.actionListeners.size()) {
            headerButton.addActionListener((JCActionListener)this.actionListeners.elementAt(n));
            ++n;
        }
        if (!this.num_columns_set) {
            this.data.setNumColumns(this.getNumColumns() + 1);
        }
        this.add(headerButton);
        this.updateParent();
        return headerButton;
    }

    public void updateParent() {
        if (this.update_parent && this.getPeer() != null) {
            this.data.calcColumnWidths();
            this.invalidate();
            Container container = this.getParent();
            if (container instanceof Viewport) {
                container = container.getParent();
            }
            container.invalidate();
            container.validate();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.data.calcColumnWidths();
    }

    public void layout() {
        int n;
        int n2 = 0;
        Component[] componentArray = this;
        synchronized (componentArray) {
            n2 = this.getNumColumns();
            if (n2 == 0 && this.comp != null && !this.num_columns_set) {
                n = this.num_columns_set;
                this.num_columns_set = true;
                n2 = this.comp.getNumColumns();
                this.setNumColumns(n2);
                this.num_columns_set = n;
            }
        }
        componentArray = this.getComponents();
        int n3 = 0;
        n = super.firstColumnOffset();
        int n4 = 0;
        while (n4 < componentArray.length) {
            JCLabel jCLabel = (JCLabel)componentArray[n4];
            if (n4 >= n2) {
                jCLabel.hide();
            } else {
                Insets insets = jCLabel.getInsets();
                insets.left = this.getColumnLeftMargin(n4) - jCLabel.getBorderThickness();
                insets.right = this.getColumnRightMargin(n4) - jCLabel.getBorderThickness();
                jCLabel.setInsets(insets);
                int n5 = this.getColumnDisplayWidth(n4);
                if (n4 == 0) {
                    insets = jCLabel.getInsets();
                    insets.left += n;
                    jCLabel.setInsets(insets);
                }
                jCLabel.alignment = this.getColumnAlignment(n4);
                JCComponent.setBounds(jCLabel, n3, 0, n5 + jCLabel.getBorderThickness(), this.size().height);
                jCLabel.show();
                n3 += n5;
            }
            ++n4;
        }
    }

    public void recalc() {
        this.data.calcColumnWidths();
        this.resize(JCComponent.getPreferredSize((Component)this).width, this.size().height);
        this.layout();
        this.repaint();
    }

    protected int preferredHeight() {
        int n = 0;
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            n = Math.max(n, JCComponent.getPreferredSize((Component)componentArray[n2]).height);
            ++n2;
        }
        return n + JCComponent.getInsets((Container)this).top + JCComponent.getInsets((Container)this).bottom;
    }

    private int firstColumnOffset() {
        int n;
        int n2 = n = this.comp != null ? this.comp.getColumnPosition(0) : 0;
        if (this.comp instanceof JCScrollableInterface) {
            n += ((JCScrollableInterface)((Object)this.comp)).getHorizOrigin();
        }
        return n;
    }

    protected int preferredWidth() {
        JCComponent jCComponent = (JCComponent)((Object)this.comp);
        if (jCComponent == null) {
            return this.data.preferredWidth();
        }
        return this.data.preferredWidth() + 2 * jCComponent.getBorderThickness() + 2 * jCComponent.getHighlightThickness() + JCComponent.getInsets((Container)this).left + JCComponent.getInsets((Container)this).right;
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = this.preferredWidth();
        return dimension;
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.addUnique(jCActionListener);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCButton) {
                ((JCButton)componentArray[n]).addActionListener(jCActionListener);
            }
            ++n;
        }
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCButton) {
                ((JCButton)componentArray[n]).removeActionListener(jCActionListener);
            }
            ++n;
        }
        this.actionListeners.removeElement(jCActionListener);
    }

    protected boolean mouseMove(Event event) {
        if (this.resizing) {
            return true;
        }
        JCComponent jCComponent = (JCComponent)event.target;
        this.resize_col = this.getComponent(jCComponent);
        if (this.getColumnResizePolicy() != 1) {
            if (event.x > jCComponent.size().width - 5) {
                jCComponent.setCursor(10);
                return true;
            }
            if (event.x < 5) {
                --this.resize_col;
                while (this.data.getColumnDisplayWidth(this.resize_col) == 0 && this.resize_col >= 0) {
                    --this.resize_col;
                }
                if (this.getColumnResizePolicy() == 2 && this.resize_col < 0 && this.data.getColumnDisplayWidth(0) == 0) {
                    this.resize_col = Math.max(0, this.resize_col);
                }
                if (this.resize_col >= 0) {
                    jCComponent.setCursor(10);
                    return true;
                }
            }
        }
        return this.mouseExit(event);
    }

    protected boolean mouseExit(Event event) {
        if (this.resizing) {
            return true;
        }
        this.resize_col = -999;
        this.setCursor(0);
        return true;
    }

    protected boolean mouseDown(Event event) {
        if (this.resize_col == -999 || this.getColumnResizePolicy() == 1) {
            return false;
        }
        this.resizing = true;
        JCComponent jCComponent = (JCComponent)event.target;
        this.mouse_down_x = event.x + jCComponent.location().x;
        this.drawLine(false, this.mouse_down_x);
        return true;
    }

    protected boolean mouseDrag(Event event) {
        if (!this.resizing || this.getColumnResizePolicy() == 1) {
            return false;
        }
        Component component = (Component)event.target;
        int n = event.x + component.location().x;
        if (this.getColumnResizePolicy() == 0 && n - this.getColumnPosition(this.resize_col) - this.getColumnLeftMargin(this.resize_col) < 20) {
            return false;
        }
        this.drawLine(true, 0);
        this.drawLine(false, n);
        return true;
    }

    protected boolean mouseUp(Event event) {
        JCMultiColumnInterface jCMultiColumnInterface;
        if (!this.resizing) {
            return false;
        }
        Component component = (Component)event.target;
        this.drawLine(true, 0);
        int n = event.x + component.location().x;
        n -= this.firstColumnOffset();
        int n2 = this.getColumnResizePolicy();
        int n3 = 0;
        if (n2 == 0) {
            n3 = Math.max(10, this.getColumnWidth(this.resize_col) + n - this.getColumnPosition(this.resize_col + 1) + this.firstColumnOffset());
        } else if (n2 == 2) {
            n3 = n - this.mouse_down_x;
        }
        JCMultiColumnInterface jCMultiColumnInterface2 = jCMultiColumnInterface = this.comp != null ? this.comp : this;
        if (n2 == 0) {
            jCMultiColumnInterface.setColumnWidth(this.resize_col, n3);
            jCMultiColumnInterface.setColumnDisplayWidth(this.resize_col, n3);
        } else if (n2 == 2) {
            int n4 = 0;
            int n5 = 0;
            int n6 = Math.abs(n3);
            boolean bl = n3 > 0;
            int n7 = this.resize_col;
            while (n6 > 0 && n7 >= 0) {
                int n8 = this.getColumnDisplayWidth(n7);
                int n9 = this.getColumnWidth(n7);
                if (bl) {
                    if (n8 >= n9 && this.getColumnDisplayWidth(n7 + 1) != 0) break;
                    if (n8 + n6 > n9) {
                        n5 = n9;
                        n4 = Math.max(0, n9 - n8);
                    } else {
                        n5 = n8 + n6;
                        n4 = n6;
                    }
                } else {
                    n4 = Math.min(this.getColumnDisplayWidth(n7), n6);
                    n5 = this.getColumnDisplayWidth(n7) - n4;
                }
                jCMultiColumnInterface.setColumnDisplayWidth(n7, n5);
                n6 -= n4;
                if (bl) {
                    ++n7;
                    continue;
                }
                --n7;
            }
        }
        this.resize_col = -999;
        this.resizing = false;
        this.setCursor(0);
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.resizing) {
            return false;
        }
        this.resize_col = -999;
        this.resizing = false;
        this.setCursor(0);
        return true;
    }

    protected void drawLine(boolean bl, int n) {
        if (!bl) {
            x_save = n;
        } else if (x_save == -999) {
            return;
        }
        n = x_save;
        Component component = this.locate(n, 0);
        if (component == null) {
            return;
        }
        Graphics graphics = component.getGraphics();
        graphics.translate(-component.location().x, 0);
        graphics.setXORMode(this.getBackground());
        graphics.drawLine(n, 0, n, this.size().height);
        graphics.dispose();
    }

    public int calcWidth(int n) {
        int[] nArray;
        Component[] componentArray = this.getComponents();
        if (n >= componentArray.length) {
            return 0;
        }
        JCLabel jCLabel = (JCLabel)componentArray[n];
        int n2 = 0;
        int[] nArray2 = nArray = this.comp != null ? this.comp.getColumnWidths() : new int[]{};
        if (this.comp != null) {
            int n3 = this.getColumnLeftMargin(n) + this.getColumnRightMargin(n);
            n2 = this.comp.getColumnWidth(n);
            if (n < nArray.length && nArray[n] != -998) {
                if (n2 - n3 > 0) {
                    return n2;
                }
                n2 = 0;
            }
        }
        Insets insets = jCLabel.getInsets();
        insets.left = this.getColumnLeftMargin(n);
        insets.right = this.getColumnRightMargin(n);
        jCLabel.setInsets(insets);
        int n4 = JCComponent.getPreferredSize((Component)jCLabel).width - jCLabel.getBorderThickness();
        if (n4 > n2 && n < nArray.length && nArray[n] == -998 && this.comp.getMultiColumnData() != null) {
            this.comp.getMultiColumnData().setColumnWidthInternal(n, n4);
        }
        return Math.max(n2, n4);
    }

    public int[] getColumnWidths() {
        return this.data.getColumnWidths();
    }

    public void setColumnWidths(int[] nArray) {
        this.data.setColumnWidths(nArray);
        this.layout();
        this.resize(JCComponent.getPreferredSize((Component)this).width, this.size().height);
        this.repaint();
    }

    public int getColumnDisplayWidth(int n) {
        int n2 = this.data.getColumnDisplayWidth(n);
        if ((n == 0 || n == this.data.getNumColumns() - 1) && this.comp != null && this.comp instanceof JCComponent) {
            JCComponent jCComponent = (JCComponent)((Object)this.comp);
            if (n == 0) {
                n2 += jCComponent.getBorderThickness() + JCComponent.getInsets((Container)this).left;
            } else if (n2 > 0 && this.getColumnResizePolicy() == 2) {
                n2 += jCComponent.getBorderThickness() + JCComponent.getInsets((Container)this).right + jCComponent.getHighlightThickness();
            }
        }
        return n2;
    }

    public void setColumnWidth(int n, int n2) {
        int n3 = n2 - this.data.getColumnWidth(n);
        this.data.setColumnWidth(n, n2);
        if (this.getParent() == null) {
            return;
        }
        int n4 = this.getParent() instanceof Viewport ? Math.max(this.size().width + n3, this.getParent().size().width) : JCComponent.getPreferredSize((Component)this).width;
        this.resize(n4, this.size().height);
        this.updateParent();
        this.repaint();
    }

    public int getNumColumns() {
        return this.data.num_columns;
    }

    public void setNumColumns(int n) {
        this.data.setNumColumns(n != -998 ? n : this.countComponents());
        this.num_columns_set = n != -998;
        this.data.calcColumnWidths();
        if (!this.batched) {
            this.resize(JCComponent.getPreferredSize((Component)this).width, this.size().height);
            this.updateParent();
        }
    }

    public int[] getColumnAlignments() {
        return this.data.getColumnAlignments();
    }

    public int getColumnAlignment(int n) {
        return this.data.getColumnAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        this.data.setColumnAlignment(n, n2);
        if (n < this.countComponents()) {
            ((JCLabel)this.getComponent(n)).setAlignment(n2);
        }
        this.repaint();
    }

    public void setColumnAlignments(int[] nArray) {
        this.data.setColumnAlignments(nArray);
        this.layout();
        this.repaint();
    }

    public int getColumnPosition(int n) {
        return this.data.getColumnPosition(n) + JCComponent.getInsets((Container)this).left;
    }

    public int getColumnLeftMargin(int n) {
        return this.data.getColumnLeftMargin(n);
    }

    public void setColumnLeftMargin(int n, int n2) {
        int n3 = this.getColumnLeftMargin(n);
        this.data.setColumnLeftMargin(n, n2);
        if (this.getParent() == null || n >= this.getNumColumns()) {
            return;
        }
        this.resize(this.size().width + n2 - n3, this.size().height);
        this.updateParent();
    }

    public int getColumnRightMargin(int n) {
        return this.data.getColumnRightMargin(n);
    }

    public void setColumnRightMargin(int n, int n2) {
        int n3 = this.getColumnRightMargin(n);
        this.data.setColumnRightMargin(n, n2);
        if (this.getParent() == null || n >= this.getNumColumns()) {
            return;
        }
        this.resize(this.size().width + n2 - n3, this.size().height);
        this.updateParent();
    }

    public JCMultiColumnData getMultiColumnData() {
        return this.data;
    }

    public int[] getColumnDisplayWidths() {
        return this.data.getColumnDisplayWidths();
    }

    public void setColumnDisplayWidths(int[] nArray) {
        this.data.setColumnDisplayWidths(nArray);
        this.layout();
        this.resize(JCComponent.getPreferredSize((Component)this).width, this.size().height);
        this.repaint();
    }

    public int getColumnWidth(int n) {
        return this.data.getColumnWidth(n);
    }

    public void setColumnDisplayWidth(int n, int n2) {
        int n3 = n2 - this.data.getColumnDisplayWidth(n);
        this.data.setColumnDisplayWidth(n, n2);
        if (this.getParent() == null) {
            return;
        }
        int n4 = this.getParent() instanceof Viewport ? Math.max(this.size().width + n3, this.getParent().size().width) : JCComponent.getPreferredSize((Component)this).width;
        this.resize(n4, this.size().height);
        this.updateParent();
        this.repaint();
    }

    public int getColumnResizePolicy() {
        return this.data.getColumnResizePolicy();
    }

    public void setColumnResizePolicy(int n) {
        this.data.setColumnResizePolicy(n);
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    static {
        x_save = -999;
    }
}

